#ifdef GL_ES
precision mediump float;

varying vec2 vTexCoord;
vec4 fragColor;
#else
in vec2 vTexCoord;
out vec4 fragColor;
#endif
uniform sampler2D colorTex;

void main()
{
#ifdef GL_ES
	vec4 readColor = texture2D(colorTex, vTexCoord.st);
    gl_FragColor = vec4(readColor.rgb * readColor.a, readColor.a);
#else
	vec4 readColor = texture(colorTex, vTexCoord.st);
    fragColor = vec4(readColor.rgb * readColor.a, readColor.a);
#endif
}
